<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="ltr">

<head>
    <!-- META DATA -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="manoar">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'BD Travel')); ?></title>
    <!-- FAVICON -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('favicon.ico')); ?>" />

    <!-- STYLE CSS -->
    <link href="<?php echo e(asset('backend/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('backend/css/style.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('backend/css/dark-style.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('backend/css/transparent-style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('backend/css/skin-modes.css')); ?>" rel="stylesheet" />

    <!--- FONT-ICONS CSS -->
    <link href="<?php echo e(asset('backend/css/icons.css')); ?>" rel="stylesheet" />

    
    <link href="<?php echo e(asset('vendor/cute-alert/cute-alert.css')); ?>" rel="stylesheet" />

    <!-- COLOR SKIN CSS -->
    <link id="theme" rel="stylesheet" type="text/css" media="all" href="<?php echo e(asset('backend/colors/color1.css')); ?>" />
    <?php echo app('Illuminate\Foundation\Vite')('resources/js/app.js'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>

    <?php if(isset($style)): ?>
    <?php echo e($style); ?>

    <?php endif; ?>
</head>

<body class="app sidebar-mini ltr">

    <!-- GLOBAL-LOADER -->
    <div id="global-loader">
        <img src="<?php echo e(asset('backend/images/loader.svg')); ?>" class="loader-img" alt="Loader">
    </div>
    <!-- /GLOBAL-LOADER -->

    <!-- PAGE -->
    <div class="page">
        <div class="page-main">

            <!-- app-Header -->
            <?php echo $__env->make('layouts.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- /app-Header -->

            <!--APP-SIDEBAR-->
            <?php echo $__env->make('layouts.include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!--app-content open-->
            <div class="main-content app-content mt-0">
                <div class="side-app">

                    <!-- CONTAINER -->
                    <div class="main-container container-fluid">
                        <!-- Page Heading -->
                        <?php if(isset($header)): ?>
                        <!-- PAGE-HEADER -->
                        <div class="page-header">
                            <h1 class="page-title">
                                <?php echo e($header); ?>

                            </h1>
                        </div>
                        <!-- PAGE-HEADER END -->
                        <?php endif; ?>

                        <!-- Page Content -->
                        <main>
                            <?php echo e($slot); ?>

                        </main>

                    </div>
                    <!-- CONTAINER CLOSED -->

                </div>
            </div>
            <!--app-content closed-->
        </div>

        <!-- FOOTER -->
        <footer class="footer">
            <div class="container">
                <div class="row align-items-center flex-row-reverse">
                    <div class="col-md-12 col-sm-12 text-center">
                        Copyright &copy; <span id="year"></span> <a href="javascript:void(0)">BD Travel</a>  All rights reserved.
                    </div>
                </div>
            </div>
        </footer>
        <!-- FOOTER CLOSED -->

        <!-- Sidebar-right -->
        
        <!--/Sidebar-right-->
        <?php echo $__env->make('layouts.include.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>

    <!-- BACK-TO-TOP -->
    <a href="#top" id="back-to-top"><i class="fa fa-angle-up"></i></a>

    <!-- JQUERY JS -->
    <script src="<?php echo e(asset('backend/js/jquery.min.js')); ?>"></script>

    <!-- BOOTSTRAP JS -->
    <script src="<?php echo e(asset('backend/plugins/bootstrap/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>

    <!-- SPARKLINE JS-->
    <script src="<?php echo e(asset('backend/js/jquery.sparkline.min.js')); ?>"></script>

    <!-- CHART-CIRCLE JS-->
    <script src="<?php echo e(asset('backend/js/circle-progress.min.js')); ?>"></script>

    <!-- C3 CHART JS-->
    <script src="<?php echo e(asset('backend/plugins/charts-c3/d3.v5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/charts-c3/c3-chart.js')); ?>"></script>

    <!-- INPUT MASK JS-->
    <script src="<?php echo e(asset('backend/plugins/input-mask/jquery.mask.min.js')); ?>"></script>

    <!-- SIDE-MENU JS -->
    <script src="<?php echo e(asset('backend/plugins/sidemenu/sidemenu.js')); ?>"></script>

    <!-- SIDEBAR JS -->
    <script src="<?php echo e(asset('backend/plugins/sidebar/sidebar.js')); ?>"></script>

    <!-- Perfect SCROLLBAR JS-->
    

    <!-- Color Theme js -->
    <script src="<?php echo e(asset('backend/js/themeColors.js')); ?>"></script>

    <!-- Sticky js -->
    <script src="<?php echo e(asset('backend/js/sticky.js')); ?>"></script>

    <!-- Cute Alert -->
    <script src="<?php echo e(asset('vendor/cute-alert/cute-alert.js')); ?>"></script>

    <!-- CUSTOM JS -->
    <script src="<?php echo e(asset('backend/js/custom.js')); ?>"></script>
    <?php echo $__env->make('layouts.include.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php if(isset($script)): ?>
    <?php echo e($script); ?>

    <?php endif; ?>
</body>

</html>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/layouts/app.blade.php ENDPATH**/ ?>